import { makeStyles } from '@material-ui/core/styles';
import { BUTTON_COLOR } from 'constants/colors';

const useStyles = makeStyles(() => ({
    modalContainer: {
        width: 500,
        position: 'absolute',
        transform: 'translate(-50%, -50%)',
        top: '50%',
        left: '50%',
        boxShadow:
            '0 11px 15px -7px rgba(0, 0, 0, 0.2), 0 9px 46px 8px rgba(0, 0, 0, 0.12), 0 24px 38px 3px rgba(0, 0, 0, 0.14)',
        backgroundColor: '#fafafa',
        display: 'flex',
        flexDirection: 'column',
        padding: '30px 30px 14px 30px'
    },
    modalTitle: {
        fontWeight: 'bold',
        fontstretch: 'condensed',
        fontSize: 22,
        marginTop: 10
    },
    modalButtonContainer: {
        display: 'flex',
        flexDirection: 'row',
        justifyContent: 'flex-end',
        padding: '14px 30px 0',
        margin: '16px -30px 0',
        borderTop: '1px solid #e4e8eb'
    },
    modalVersionsContainer: {
        marginTop: 24
    },
    versionRadioOptionChecked: {
        color: `${BUTTON_COLOR} !important`
    },
    installButton: {
        marginLeft: 16
    }
}));

export default useStyles;
